define([
    'underscore',
    'backbone',
    'modules/appointments/appointments-radio',
    'modules/appointments/messages/request-message',
], function(
    _,
    Backbone,
    radio,
    MessageModel) {
    'use strict';

    return Backbone.View.extend({
        initialize: function(requestModel) {
            this.requestModel = requestModel || '';
            this.model = new MessageModel();
        },


        checkForMessage: function(model) {
            var message = model.get('newMessage');
            if (message) {
                this.saveRequestMessage(message, this.requestModel);
                return;
            }
            this.navigateToRequestDetails(this.requestModel);
        },

        /**
         * @param {string} message
         * @param {Backbone.Model} request
         * @return {void}
         */
        saveRequestMessage: function(message, request) {
            var userId = this.requestModel.get('userId') || this.requestModel.get('patientIdentifier').uniqueId;
            var navigate;
            if (userId) {
                navigate = _.partial(this.navigateToRequestDetails, request);

                this.listenTo(this.model, 'save:success', _.bind(navigate, this));
                this.model.saveMessage(message, request, userId);

            }
        },

        /**
         * @param {Backbone.Model} model
         * @return {void}
         */
        navigateToRequestDetails: function(model) {
            radio.trigger('appointments:request:selected', model, {showFeedbackLink: true});
        },

    });
});

